#include <iostream>
#include <algorithm>

using namespace std;

const long long e = 1e9 + 7;

struct zid
{
    long long pozicija;
    long long stabilnost;
};

bool uporedi (zid prvi, zid drugi)
{
    return prvi.pozicija < drugi.pozicija;
}

int bp(zid niz[], int n)
{
    int l = 0;
    int d = n - 1;
    int s;
    while (l < d)
    {
        s = l + (d - l)/2;
        if (niz[s].pozicija > 0)
        {
            d = s - 1;
        }
        else if(niz[s].pozicija < 0)
        {
            l = s + 1;
        }
        else
            return s;
    }
    return l;
}
int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int n;
    cin >> n;
    zid zidovi[n];

    for(int i = 0; i < n; i++)
    {
        int stabilnost, pozicija;
        cin >> pozicija >> stabilnost;
        zidovi[i].pozicija = pozicija;
        zidovi[i].stabilnost = stabilnost;
    }

    sort(zidovi, zidovi + n, uporedi);

    int p = bp(zidovi, n);

    bool nema_zidova = false;
    long long vreme = 0;
    bool desno = true;
    if (zidovi[p].pozicija < 0)
        nema_zidova = true;
    else
    {
        vreme = zidovi[p].pozicija;
        zidovi[p].stabilnost -= 1;
        desno = false;
    }
    long long magacin = 0;
    while (!nema_zidova)
    {
        if (desno)
        {
            p++;
            magacin = (magacin + abs(zidovi[p].pozicija - zidovi[p-1].pozicija)) % e;
        }
        else
        {
            p--;
            magacin = (magacin + abs(zidovi[p].pozicija - zidovi[p+1].pozicija)) % e;
        }
        if (p > n-1 || p < 0)
        {
            nema_zidova = true;
        }
        else
        {
            if (desno && zidovi[p].stabilnost != 0)
            {
                desno = false;
                zidovi[p].stabilnost--;
                vreme = (vreme + magacin) % e;
                magacin = 0;
            }
            else if (!desno && zidovi[p].stabilnost != 0)
            {
                desno = true;
                zidovi[p].stabilnost--;
                vreme = (vreme + magacin) % e;
                magacin = 0;
            }
        }
    }
    cout << vreme;
    return 0;
}